/*
 * Decompiled with CFR 0.152.
 */
package com.lazrproductions.lazrslib.client.ui.element;

import com.lazrproductions.lazrslib.client.font.FontUtilities;
import com.lazrproductions.lazrslib.client.screen.base.ScreenRect;
import com.lazrproductions.lazrslib.client.ui.Alignment;
import com.lazrproductions.lazrslib.client.ui.OnClickFunction;
import com.lazrproductions.lazrslib.client.ui.element.AbstractElement;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public class LinkElement
extends AbstractElement {
    final Component text;
    final int color;
    final int highlightedColor;
    final Alignment alignText;
    final OnClickFunction supplier;

    public LinkElement(@Nonnull Minecraft instance, @Nonnull Component text, Alignment textAlignment, OnClickFunction supplier, int height, int color, int highlightedColor) {
        super(instance, height);
        this.text = text;
        this.alignText = textAlignment;
        this.color = color;
        this.highlightedColor = highlightedColor;
        this.supplier = supplier;
    }

    public LinkElement(@Nonnull Minecraft instance, int width, @Nonnull Component text, Alignment textAlignment, OnClickFunction supplier, int color, int highlightedColor) {
        super(instance, instance.f_91062_.m_239133_((FormattedText)text, width));
        this.text = text;
        this.alignText = textAlignment;
        this.color = color;
        this.highlightedColor = highlightedColor;
        this.supplier = supplier;
    }

    @Override
    public void draw(@Nonnull Minecraft instance, @Nonnull GuiGraphics graphics, @Nonnull ScreenRect area, int mouseX, int mouseY, boolean mouseDown) {
        int textWidth = instance.f_91062_.m_92852_((FormattedText)this.text);
        Objects.requireNonNull(instance.f_91062_);
        int textHeight = 9;
        if (FontUtilities.drawLink(instance, graphics, this.alignText.fitToArea(area.toBlitCoordinates(), textWidth, textHeight), this.text, this.color, this.highlightedColor, false, mouseX, mouseY, mouseDown)) {
            this.supplier.call();
        }
    }
}

